/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.util.Comparators;
import javax.annotation.Nonnull;

public class CumulativeAction
extends Action {
    private final String cumulationType;
    private final double fill;
    private final double maxFill;

    private CumulativeAction(Builder bob) {
        super(bob);
        Preconditions.checkNotNull(bob.cumulationType, "Cumulation type must be specified.");
        Preconditions.checkArgument(bob.fill > 0.0, "Fill must be positive.");
        Preconditions.checkArgument(bob.maxFill > 0.0 && bob.maxFill <= bob.fill, "MaxFill must be positive and less than fill.");
        this.cumulationType = bob.cumulationType;
        this.fill = bob.fill;
        this.maxFill = bob.maxFill;
    }

    public String getCumulationType() {
        return this.cumulationType;
    }

    public double getFill() {
        return this.fill;
    }

    public double getMaxFill() {
        return this.maxFill;
    }

    @Override
    @Nonnull
    public Action.Divisibility getDivisibility() {
        return Action.Divisibility.INDIVISIBLE;
    }

    @Override
    public long getProductionTime() {
        return this.productionTime;
    }

    @Override
    public long timeToMake(double q) {
        double cisterns;
        Preconditions.checkArgument(q > -1.0E-7, "The qty must be greater than or equal to 0.");
        if (q < 0.0) {
            q = 0.0;
        }
        int noOfCists = Comparators.equals(cisterns = q / this.maxFill, (int)cisterns, 1.0E-7) ? (int)Math.round(cisterns) : (int)Math.ceil(cisterns);
        return LongMath.checkedMultiply(noOfCists, this.getProductionTime());
    }

    @Override
    public long normtime(double q) {
        return (long)Math.ceil(q * (double)this.getProductionTime() / this.fill);
    }

    public static class Builder
    extends Action.Builder {
        private String cumulationType;
        private double fill;
        private double maxFill;

        public void setCumulationType(String cumulationType) {
            this.cumulationType = cumulationType;
        }

        public void setFill(double fill) {
            this.fill = fill;
        }

        public void setMaxFill(double maxFill) {
            this.maxFill = maxFill;
        }

        @Override
        public void reset() {
            super.reset();
            this.setCumulationType(null);
            this.setFill(0.0);
            this.setMaxFill(0.0);
        }

        @Override
        public boolean isValid() {
            return super.isValid() && !this.joinedWithFollowing && this.fill > 0.0 && (this.maxFill == 0.0 || this.maxFill > 0.0 && this.maxFill <= this.fill);
        }

        @Override
        public CumulativeAction build() {
            if (this.maxFill == 0.0) {
                this.maxFill = this.fill;
            }
            Preconditions.checkState(this.isValid(), "Cannot build cumulative action. Properties of the action are not valid.");
            return new CumulativeAction(this);
        }
    }
}

